package id3;

import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractExample {

    private String category = null;
    private Map<String, AbstractProperty> properties = new HashMap<String, AbstractProperty>();

	public AbstractExample(AbstractProperty... propertyList) throws IllegalArgumentException {
		addProperties(propertyList);
	}

	public AbstractExample(String category, AbstractProperty... propertyList) throws IllegalArgumentException {
		
		if(isLegalCategory(category) == false)
			throw new IllegalArgumentException(category + "is an illegal category for the example.");
		this.category = category;

		addProperties(propertyList);
	}
	
	private void addProperties(AbstractProperty[] propertyList) throws IllegalArgumentException
	{
		Set<String> requiredProps = getPropertyNames();
		
		for(int i = 0; i < propertyList.length; i++){
			AbstractProperty prop = propertyList[i];
			if(requiredProps.contains(prop.getName()) == false)
				throw new IllegalArgumentException(prop.getName() + "is an illegal Property for example.");
			properties.put(prop.getName(), prop);
			
			requiredProps.remove(prop.getName());
		}
		
		if(requiredProps.isEmpty() == false){
			Object[] p = requiredProps.toArray();
			String props = "";
			for (int i = 0; i < p.length; i++)
				props += (String)p[i] + " ";
			throw new IllegalArgumentException("Missing Properties in example: " + props);
		}
		
	}
    
	public AbstractProperty getProperty(String name){
		return properties.get(name);
	}
	
	public String getCategory(){
		return category;
	}
	
	public String toString(){
		String s = category;
		
		Collection<AbstractProperty> props = properties.values();
		Iterator<AbstractProperty> iter = props.iterator();
		
		while(iter.hasNext()){
			AbstractProperty p = iter.next();
			s += ", " + p.getName() + "=" + p.getValue();
		}
		
		return s;
	}
	
	public abstract Set<String> getPropertyNames();
	public abstract boolean isLegalCategory(String cat);
}
